/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.gametest;

import com.blamejared.crafttweaker.gametest.CraftTweakerGameTestHolder;
import com.blamejared.crafttweaker.gametest.Modifier;
import com.blamejared.crafttweaker.platform.Services;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.JUnitLikeTestReporter;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestReporter;
import net.minecraft.world.level.block.Rotation;

public class CraftTweakerGameTests {
    @GameTestGenerator
    public static List<TestFunction> getTests() {
        ArrayList<TestFunction> functions = new ArrayList<TestFunction>();
        Services.PLATFORM.findClassesWithAnnotation(CraftTweakerGameTestHolder.class).forEach(aClass -> {
            for (Method method : aClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(GameTest.class)) continue;
                GameTest annotation = method.getAnnotation(GameTest.class);
                String className = aClass.getSimpleName().toLowerCase();
                String testName = className + "." + method.getName().toLowerCase();
                Object template = annotation.m_177046_().isEmpty() ? testName : annotation.m_177046_();
                String batch = annotation.m_177043_();
                Rotation rotation = StructureUtils.m_127835_((int)annotation.m_177044_());
                ModifingConsumer consumer = new ModifingConsumer((Class<?>)aClass, method, Modifier.from(method));
                functions.add(new TestFunction(batch, testName, (String)template, rotation, annotation.m_177042_(), annotation.m_177047_(), annotation.m_177045_(), annotation.m_177049_(), annotation.m_177048_(), (Consumer)consumer));
            }
        });
        if (!functions.isEmpty()) {
            try {
                GlobalTestReporter.m_177655_((TestReporter)new JUnitLikeTestReporter(new File("game-test-results.xml")));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return functions;
    }

    public static class ModifingConsumer
    implements Consumer<GameTestHelper> {
        private final Class<?> testClass;
        private final Method testMethod;
        private final Modifier modifier;

        public ModifingConsumer(Class<?> testClass, Method testMethod, Modifier modifier) {
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.modifier = modifier;
        }

        @Override
        public void accept(GameTestHelper gameTestHelper) {
            Object instance;
            try {
                instance = this.testClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error while creating test class " + this.testClass, e.getCause());
            }
            try {
                this.testMethod.invoke(instance, gameTestHelper);
                if (this.modifier.isImplicitSuccession()) {
                    gameTestHelper.m_177412_();
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(this.testMethod.getName(), this.testMethod.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

